"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const TABLE_NAME = 'portal_one_time_tokens';
async function up(query) {
    await query.createTable(TABLE_NAME, {
        id: {
            type: _sequelize.DataTypes.TEXT,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4'),
            allowNull: false,
            primaryKey: true
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        portal_user_id: {
            type: _sequelize.DataTypes.TEXT,
            references: {
                model: 'portal_users',
                key: 'id'
            },
            onDelete: 'CASCADE',
            allowNull: false
        },
        type: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            defaultValue: 'login'
        },
        token: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        expires_at: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: false
        }
    });
    await query.addIndex(TABLE_NAME, [
        'portal_user_id'
    ], {
        name: `idx_${TABLE_NAME}_portal_user_id`
    });
}
async function down(query) {
    await query.removeIndex(TABLE_NAME, `idx_${TABLE_NAME}_portal_user_id`);
    await query.dropTable(TABLE_NAME, {});
}

//# sourceMappingURL=1755780000000-addPortalOneTimeTokensTable.js.map