"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const INVOICE_PRICE_LISTS = 'invoice_price_lists';
const INVOICE_PRICE_LIST_ITEMS = 'invoice_price_list_items';
const baseFields = {
    id: {
        type: _sequelize.DataTypes.TEXT,
        defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4'),
        allowNull: false,
        primaryKey: true
    },
    created_at: {
        type: _sequelize.DataTypes.DATE,
        defaultValue: _sequelize.Sequelize.fn('now'),
        allowNull: false
    },
    updated_at: {
        type: _sequelize.DataTypes.DATE,
        defaultValue: _sequelize.Sequelize.fn('now'),
        allowNull: false
    },
    deleted_at: {
        type: _sequelize.DataTypes.DATE,
        allowNull: true
    },
    updated_at_sync_tick: {
        type: _sequelize.DataTypes.BIGINT,
        allowNull: false,
        defaultValue: 0
    }
};
async function up(query) {
    // price_lists
    await query.createTable(INVOICE_PRICE_LISTS, {
        ...baseFields,
        code: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        name: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        rules: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: true
        },
        visibility_status: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            defaultValue: 'current'
        }
    });
    await query.addIndex(INVOICE_PRICE_LISTS, [
        'code'
    ], {
        name: `idx_${INVOICE_PRICE_LISTS}_code_unique`,
        unique: true
    });
    // invoice_price_list_items
    await query.createTable(INVOICE_PRICE_LIST_ITEMS, {
        ...baseFields,
        invoice_price_list_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            references: {
                model: INVOICE_PRICE_LISTS,
                key: 'id'
            },
            onDelete: 'CASCADE'
        },
        invoice_product_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            references: {
                model: 'invoice_products',
                key: 'id'
            },
            onDelete: 'CASCADE'
        },
        price: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: true
        }
    });
    await query.addIndex(INVOICE_PRICE_LIST_ITEMS, [
        'invoice_price_list_id'
    ], {
        name: `idx_${INVOICE_PRICE_LIST_ITEMS}_price_list_id`
    });
    await query.addIndex(INVOICE_PRICE_LIST_ITEMS, [
        'invoice_price_list_id',
        'invoice_product_id'
    ], {
        name: `idx_${INVOICE_PRICE_LIST_ITEMS}_price_list_id_invoice_product_id_unique`,
        unique: true
    });
}
async function down(query) {
    await query.removeIndex(INVOICE_PRICE_LIST_ITEMS, `idx_${INVOICE_PRICE_LIST_ITEMS}_price_list_id_invoice_product_id_unique`);
    await query.removeIndex(INVOICE_PRICE_LIST_ITEMS, `idx_${INVOICE_PRICE_LIST_ITEMS}_price_list_id`);
    await query.dropTable(INVOICE_PRICE_LIST_ITEMS, {});
    await query.removeIndex(INVOICE_PRICE_LISTS, `idx_${INVOICE_PRICE_LISTS}_code_unique`);
    await query.dropTable(INVOICE_PRICE_LISTS, {});
}

//# sourceMappingURL=1756000000000-addPriceListsAndItemsTables.js.map