"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('appointment_procedure_types', {
        id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.DataTypes.UUIDV4
        },
        appointment_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'appointments',
                key: 'id'
            },
            onDelete: 'CASCADE'
        },
        procedure_type_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.DataTypes.NOW
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.DataTypes.NOW
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.addIndex('appointment_procedure_types', [
        'appointment_id',
        'procedure_type_id'
    ], {
        unique: true,
        name: 'unique_appointment_procedure_type'
    });
}
async function down(query) {
    await query.dropTable('appointment_procedure_types');
}

//# sourceMappingURL=1757319805061-createAppointmentProcedureTypesTable.js.map