"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const tableName = 'invoices_invoice_insurance_plans';
const baseFields = {
    id: {
        type: _sequelize.DataTypes.TEXT,
        defaultValue: _sequelize.Sequelize.fn('gen_random_uuid'),
        allowNull: false,
        primaryKey: true
    },
    created_at: {
        type: _sequelize.DataTypes.DATE,
        defaultValue: _sequelize.Sequelize.fn('now'),
        allowNull: false
    },
    updated_at: {
        type: _sequelize.DataTypes.DATE,
        defaultValue: _sequelize.Sequelize.fn('now'),
        allowNull: false
    },
    deleted_at: {
        type: _sequelize.DataTypes.DATE,
        allowNull: true
    },
    updated_at_sync_tick: {
        type: _sequelize.DataTypes.BIGINT,
        allowNull: false,
        defaultValue: 0
    }
};
async function up(query) {
    await query.createTable(tableName, {
        ...baseFields,
        invoice_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            references: {
                model: 'invoices',
                key: 'id'
            },
            onDelete: 'CASCADE'
        },
        invoice_insurance_plan_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'invoice_insurance_plans',
                key: 'id'
            },
            onDelete: 'CASCADE'
        }
    });
    await query.addIndex(tableName, [
        'invoice_id'
    ]);
    await query.addIndex(tableName, [
        'invoice_insurance_plan_id'
    ]);
    // Remove Invoice Insurers table
    await query.dropTable('invoice_insurers');
}
async function down(query) {
    await query.dropTable(tableName);
    await query.createTable('invoice_insurers', {
        ...baseFields,
        invoice_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            references: {
                model: 'invoices',
                key: 'id'
            }
        },
        insurer_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        percentage: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: false
        }
    });
}

//# sourceMappingURL=1762221646418-createInvoicesInvoiceInsurancePlansTable.js.map