"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _constants = require("@tamanu/constants");
async function up(query) {
    await query.sequelize.query(`
    UPDATE survey_screen_components
    SET validation_criteria = (
      COALESCE(
        NULLIF(validation_criteria, '')::jsonb,
        '{}'::jsonb
      ) || '{"mandatory": true}'::jsonb
    )::text
    WHERE data_element_id = '${_constants.CHARTING_DATA_ELEMENT_IDS.dateRecorded}';
  `);
}
async function down(query) {
    await query.sequelize.query(`
    UPDATE survey_screen_components
    SET validation_criteria = CASE
      WHEN validation_criteria IS NULL OR validation_criteria = '' THEN NULL
      WHEN (validation_criteria::jsonb - 'mandatory') = '{}'::jsonb THEN NULL
      ELSE (validation_criteria::jsonb - 'mandatory')::text
    END
    WHERE data_element_id = '${_constants.CHARTING_DATA_ELEMENT_IDS.dateRecorded}';
  `);
}

//# sourceMappingURL=1763004448617-SetMandatoryValidationForPatientChartingDate.js.map