"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const TABLE = 'invoice_item_finalised_insurances';
const baseFields = {
    id: {
        type: _sequelize.DataTypes.STRING,
        defaultValue: _sequelize.Sequelize.fn('gen_random_uuid'),
        allowNull: false,
        primaryKey: true
    },
    created_at: {
        type: _sequelize.DataTypes.DATE,
        defaultValue: _sequelize.Sequelize.fn('now'),
        allowNull: false
    },
    updated_at: {
        type: _sequelize.DataTypes.DATE,
        defaultValue: _sequelize.Sequelize.fn('now'),
        allowNull: false
    },
    deleted_at: {
        type: _sequelize.DataTypes.DATE,
        allowNull: true
    },
    updated_at_sync_tick: {
        type: _sequelize.DataTypes.BIGINT,
        allowNull: false,
        defaultValue: 0
    }
};
async function up(query) {
    await query.createTable(TABLE, {
        ...baseFields,
        invoice_item_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            references: {
                model: 'invoice_items',
                key: 'id'
            },
            onDelete: 'CASCADE'
        },
        coverage_value_final: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: false
        },
        invoice_insurance_plan_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'invoice_insurance_plans',
                key: 'id'
            },
            onDelete: 'CASCADE'
        }
    });
    await query.addIndex(TABLE, [
        'invoice_insurance_plan_id'
    ]);
    await query.addIndex(TABLE, [
        'invoice_item_id',
        'invoice_insurance_plan_id'
    ], {
        unique: true,
        name: `idx_${TABLE}_id_plan_id_unique`
    });
}
async function down(query) {
    await query.dropTable(TABLE);
}

//# sourceMappingURL=1763497714759-createInvoiceItemFinalisedInsurancesTable.js.map