"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.sequelize.query(`
    UPDATE templates
    SET type = reference_data.id
    FROM reference_data
    WHERE reference_data.type = 'noteType'
      AND reference_data.code = templates.type
      AND templates.type != 'patientLetter'
    `);
}
async function down(query) {
    await query.sequelize.query(`
    UPDATE templates
    SET type = reference_data.code
    FROM reference_data
    WHERE reference_data.type = 'noteType'
      AND reference_data.id = templates.type
      AND templates.type != 'patientLetter'
    `);
}

//# sourceMappingURL=1764068008321-migrateTemplateTypesToNoteTypeReferences.js.map