"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    // In a previous migration (1759894448776-migrateNoteTypesToReferenceData.ts) we added a note_type_id column to the notes table.
    // We need to rebuild the notes in the lookup table for the notes table to ensure that lookup table state is correct.
    // Note that this may take a while on larger deployments, took ~15 mins on Nauru Clone
    await query.sequelize.query(`SELECT flag_lookup_model_to_rebuild('notes');`);
}
async function down() {
// No reverse migration
}

//# sourceMappingURL=1771806628203-RebuildNotesInLookupTableAfterAddingNoteTypeIdColumn.js.map