"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "DHIS2PushLog", {
    enumerable: true,
    get: function() {
        return DHIS2PushLog;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let DHIS2PushLog = class DHIS2PushLog extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            reportId: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            status: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            message: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: true
            },
            imported: {
                type: _sequelize.DataTypes.INTEGER,
                allowNull: true
            },
            updated: {
                type: _sequelize.DataTypes.INTEGER,
                allowNull: true
            },
            ignored: {
                type: _sequelize.DataTypes.INTEGER,
                allowNull: true
            },
            deleted: {
                type: _sequelize.DataTypes.INTEGER,
                allowNull: true
            },
            conflicts: {
                type: _sequelize.DataTypes.JSON,
                allowNull: true
            }
        }, {
            ...options,
            tableName: 'dhis2_pushes',
            syncDirection: _constants.SYNC_DIRECTIONS.DO_NOT_SYNC,
            schema: 'logs'
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ReportDefinition, {
            foreignKey: 'reportId',
            as: 'report'
        });
    }
};

//# sourceMappingURL=DHIS2PushLog.js.map