"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    afterCreateHook: function() {
        return afterCreateHook;
    },
    afterUpdateHook: function() {
        return afterUpdateHook;
    }
});
const _constants = require("@tamanu/constants");
const _hooks = require("../ImagingRequest/hooks");
const addItemAsAreaProduct = async (instance, imagingRequest)=>{
    if (!imagingRequest.encounterId) {
        return false;
    }
    if (!instance.areaId) {
        return false;
    }
    const areaProduct = await instance.sequelize.models.InvoiceProduct.findOne({
        where: {
            category: _constants.INVOICE_ITEMS_CATEGORIES.IMAGING_AREA,
            sourceRecordId: instance.areaId
        }
    });
    if (areaProduct) {
        await instance.sequelize.models.Invoice.addItemToInvoice(instance, imagingRequest.encounterId, areaProduct, imagingRequest.requestedById);
        return true;
    }
    return false;
};
const addItemAsRequestTypeProduct = async (instance, imagingRequest)=>{
    if (!imagingRequest.encounterId) {
        return false;
    }
    const requestType = await instance.sequelize.models.ReferenceData.findOne({
        where: {
            type: _constants.REFERENCE_TYPES.IMAGING_TYPE,
            code: imagingRequest.imagingType
        }
    });
    if (!requestType) {
        return false;
    }
    const requestTypeProduct = await instance.sequelize.models.InvoiceProduct.findOne({
        where: {
            category: _constants.INVOICE_ITEMS_CATEGORIES.IMAGING_TYPE,
            sourceRecordId: requestType.id
        }
    });
    if (!requestTypeProduct) {
        return;
    }
    const areaRefData = await instance.sequelize.models.ReferenceData.findByPk(instance.areaId);
    // Add note of area for reference
    await instance.sequelize.models.Invoice.addItemToInvoice(instance, imagingRequest.encounterId, requestTypeProduct, imagingRequest.requestedById, areaRefData?.name);
};
const addToInvoice = async (instance)=>{
    const imagingRequest = await instance.sequelize.models.ImagingRequest.findByPk(instance.imagingRequestId);
    if (!imagingRequest || !imagingRequest.encounterId) {
        return;
    }
    if (!await (0, _hooks.shouldAddImagingRequestToInvoice)(imagingRequest)) {
        return;
    }
    // Remove the existing imaging request item from the invoice as now we're tracking the items by their areas
    await instance.sequelize.models.Invoice.removeItemFromInvoice(imagingRequest, imagingRequest.encounterId);
    if (await addItemAsAreaProduct(instance, imagingRequest)) {
        return;
    }
    await addItemAsRequestTypeProduct(instance, imagingRequest);
};
const removeFromInvoice = async (instance)=>{
    const imagingRequest = await instance.sequelize.models.ImagingRequest.findByPk(instance.imagingRequestId);
    if (!imagingRequest || !imagingRequest.encounterId) {
        return;
    }
    await instance.sequelize.models.Invoice.removeItemFromInvoice(instance, imagingRequest.encounterId);
};
const afterCreateHook = async (instance)=>{
    await addToInvoice(instance);
};
const afterUpdateHook = async (instance)=>{
    if (instance.deletedAt) {
        await removeFromInvoice(instance);
    } else {
        await addToInvoice(instance);
    }
};

//# sourceMappingURL=hooks.js.map