"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ImagingTypeExternalCode", {
    enumerable: true,
    get: function() {
        return ImagingTypeExternalCode;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _errors = require("@tamanu/errors");
const _Model = require("./Model");
let ImagingTypeExternalCode = class ImagingTypeExternalCode extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            visibilityStatus: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false,
                defaultValue: 'current'
            },
            imagingTypeCode: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            code: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            description: _sequelize.DataTypes.TEXT
        }, {
            ...options,
            // This is reference/imported data
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
            validate: {
                mustHaveImagingType () {
                    if (!this.deletedAt && !this.imagingTypeCode) {
                        throw new _errors.InvalidOperationError('An imaging type external code must have an imaging type.');
                    }
                }
            }
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=ImagingTypeExternalCode.js.map