import { Transaction } from 'sequelize';
import { Model } from '../Model';
import { type InitOptions, type Models } from '../../types/model';
import type { Procedure } from '../Procedure';
import type { InvoiceProduct } from './InvoiceProduct';
import type { ImagingRequest } from 'models/ImagingRequest';
import type { LabTestPanelRequest } from 'models/LabTestPanelRequest';
import type { LabTest } from 'models/LabTest';
import type { ImagingRequestArea } from 'models/ImagingRequestArea';
import type { ReadSettings } from '@tamanu/settings';
type InvoiceItemSourceRecord = Procedure | LabTestPanelRequest | LabTest | ImagingRequestArea | ImagingRequest;
export declare class Invoice extends Model {
    id: string;
    displayId: string;
    date: string;
    status: string;
    patientPaymentStatus: string;
    insurerPaymentStatus: string;
    encounterId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
    static getFullReferenceAssociations(invoicePriceListId?: string): (string | {
        model: typeof import("./InvoiceDiscount").InvoiceDiscount;
        as: string;
        include: {
            model: typeof import("..").User;
            as: string;
            attributes: string[];
        }[];
    } | {
        model: typeof import("./InvoiceItem").InvoiceItem;
        as: string;
        include: ({
            model: typeof InvoiceProduct;
            as: string;
            include: Record<string, any>[];
            attributes?: undefined;
        } | {
            model: typeof import("..").User;
            as: string;
            attributes: string[];
            include?: undefined;
        } | {
            model: typeof import("./InvoiceItemDiscount").InvoiceItemDiscount;
            as: string;
            include?: undefined;
            attributes?: undefined;
        } | {
            model: typeof import("./InvoiceItemFinalisedInsurance").InvoiceItemFinalisedInsurance;
            as: string;
            include?: undefined;
            attributes?: undefined;
        })[];
    } | {
        model: typeof import("./InvoicePayment").InvoicePayment;
        as: string;
        include: ({
            model: typeof import("..").User;
            as: string;
            include?: undefined;
        } | {
            model: typeof import("./InvoicePatientPayment").InvoicePatientPayment;
            as: string;
            include: {
                model: typeof import("..").ReferenceData;
                as: string;
            }[];
        } | {
            model: typeof import("./InvoiceInsurerPayment").InvoiceInsurerPayment;
            as: string;
            include: {
                model: typeof import("..").ReferenceData;
                as: string;
            }[];
        })[];
    } | {
        model: typeof import("./InvoiceInsurancePlan").InvoiceInsurancePlan;
        as: string;
        include?: undefined;
    })[];
    static getInProgressInvoiceForEncounter(encounterId: string): Promise<Invoice | null>;
    static addItemToInvoice(newItem: InvoiceItemSourceRecord, encounterId: string, invoiceProduct: InvoiceProduct, orderedByUserId?: string, note?: string): Promise<void>;
    static removeItemFromInvoice(removedItemSource: InvoiceItemSourceRecord, encounterId: string): Promise<void>;
    static automaticallyCreateForEncounter(encounterId: string, encounterType: string, date: string, settings: ReadSettings, options?: {
        transaction?: Transaction;
    }): Promise<Invoice | null>;
}
export {};
//# sourceMappingURL=Invoice.d.ts.map