"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoiceItemFinalisedInsurance", {
    enumerable: true,
    get: function() {
        return InvoiceItemFinalisedInsurance;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("../Model");
const _sync = require("../../sync");
let InvoiceItemFinalisedInsurance = class InvoiceItemFinalisedInsurance extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            invoiceItemId: {
                type: _sequelize.DataTypes.UUID,
                allowNull: false
            },
            coverageValueFinal: {
                type: _sequelize.DataTypes.DECIMAL,
                allowNull: false
            },
            invoiceInsurancePlanId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            indexes: [
                {
                    fields: [
                        'invoiceInsurancePlanId'
                    ]
                },
                {
                    unique: true,
                    fields: [
                        'invoiceItemId',
                        'invoiceInsurancePlanId'
                    ]
                }
            ]
        });
    }
    static initRelations(models) {
        this.belongsTo(models.InvoiceItem, {
            foreignKey: 'invoiceItemId',
            as: 'invoiceItem'
        });
        this.belongsTo(models.InvoiceInsurancePlan, {
            foreignKey: 'invoiceInsurancePlanId',
            as: 'invoiceInsurancePlan'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _sync.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'invoice_items',
            'invoices',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await (0, _sync.buildEncounterLinkedLookupSelect)(this),
            joins: (0, _sync.buildEncounterLinkedLookupJoins)(this, [
                'invoice_items',
                'invoices',
                'encounters'
            ])
        };
    }
};

//# sourceMappingURL=InvoiceItemFinalisedInsurance.js.map