"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoicePriceListItem", {
    enumerable: true,
    get: function() {
        return InvoicePriceListItem;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("../Model");
let InvoicePriceListItem = class InvoicePriceListItem extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            invoicePriceListId: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            invoiceProductId: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            price: {
                type: _sequelize.DataTypes.DECIMAL,
                allowNull: true
            },
            isHidden: {
                type: _sequelize.DataTypes.BOOLEAN,
                defaultValue: false,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
            indexes: [
                {
                    fields: [
                        'invoicePriceListId'
                    ]
                },
                {
                    unique: true,
                    fields: [
                        'invoicePriceListId',
                        'invoiceProductId'
                    ]
                }
            ]
        });
    }
    static initRelations(models) {
        this.belongsTo(models.InvoicePriceList, {
            foreignKey: 'invoicePriceListId',
            as: 'invoicePriceList'
        });
        this.belongsTo(models.InvoiceProduct, {
            foreignKey: 'invoiceProductId',
            as: 'product'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=InvoicePriceListItem.js.map