import { Model } from '../Model';
import type { InitOptions, Models } from '../../types/model';
import { ReferenceData } from '../ReferenceData';
import { LabTestType } from '../LabTestType';
import { LabTestPanel } from '../LabTestPanel';
export declare class InvoiceProduct extends Model {
    id: string;
    name: string;
    insurable: boolean;
    category?: string;
    sourceRecordType?: string;
    sourceRecordId?: string;
    visibilityStatus: string;
    sourceRefDataRecord?: ReferenceData;
    sourceLabTestTypeRecord?: LabTestType;
    sourceLabTestPanelRecord?: LabTestPanel;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildSyncFilter(): null;
    static buildSyncLookupQueryDetails(): Promise<null>;
    static getFullReferenceAssociations(): string[];
    getSourceRecord(): ReferenceData | LabTestType | LabTestPanel | null | undefined;
    getProductCode(): string | null;
}
//# sourceMappingURL=InvoiceProduct.d.ts.map