"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    equalsIfPresent: function() {
        return equalsIfPresent;
    },
    matchesAgeIfPresent: function() {
        return matchesAgeIfPresent;
    },
    matchesFacilityWithExclusionaryLogic: function() {
        return matchesFacilityWithExclusionaryLogic;
    }
});
const _datefns = require("date-fns");
const equalsIfPresent = (ruleVal, inputVal)=>{
    if (ruleVal == null) {
        return true; // If ruleVal not present, return true
    }
    return ruleVal === inputVal;
};
const matchesAgeIfPresent = (condition, dob)=>{
    if (!condition) {
        return true; // If condition not present, return true
    }
    if (!dob) {
        return false;
    }
    const parsedDob = (0, _datefns.parseISO)(dob);
    if (!parsedDob || isNaN(parsedDob.getTime())) {
        return false;
    }
    const ageYears = (0, _datefns.differenceInYears)(new Date(), parsedDob);
    // Handle exact numeric value
    if (typeof condition === 'number') {
        return ageYears === condition;
    }
    // Handle object format: { min?: number, max?: number }
    const { min, max } = condition;
    const meetsMin = min === undefined || ageYears >= min;
    const meetsMax = max === undefined || ageYears <= max;
    return meetsMin && meetsMax;
};
const matchesFacilityWithExclusionaryLogic = (ruleFacilityId, inputFacilityId, allRules)=>{
    // If input facility not provided, match anything
    if (!inputFacilityId) {
        return true;
    }
    // If this rule specifies a facility, do direct comparison
    if (ruleFacilityId) {
        return ruleFacilityId === inputFacilityId;
    }
    // Rule has no facilityId - apply exclusionary logic
    const specifiedFacilityIds = new Set(allRules.map((rule)=>rule?.facilityId).filter((id)=>id != null));
    // If no rules specify facilityId, match anything
    if (specifiedFacilityIds.size === 0) {
        return true;
    }
    // Otherwise, match all facilities EXCEPT those explicitly specified
    return !specifiedFacilityIds.has(inputFacilityId);
};

//# sourceMappingURL=invoicePriceListMatching.js.map