"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "afterCreateHook", {
    enumerable: true,
    get: function() {
        return afterCreateHook;
    }
});
const _constants = require("@tamanu/constants");
const _hooks = require("../LabRequest/hooks");
const addToInvoiceAfterCreateHook = async (instance)=>{
    const labRequest = await instance.sequelize.models.LabRequest.findByPk(instance.labRequestId);
    if (!labRequest || !labRequest.encounterId) {
        return;
    }
    if (!await (0, _hooks.shouldAddLabRequestToInvoice)(labRequest)) {
        return;
    }
    if (labRequest.labTestPanelRequestId) {
        const labTestPanelRequest = await instance.sequelize.models.LabTestPanelRequest.findByPk(labRequest.labTestPanelRequestId);
        if (!labTestPanelRequest) {
            return;
        }
        const labTestPanelProduct = await instance.sequelize.models.InvoiceProduct.findOne({
            where: {
                category: _constants.INVOICE_ITEMS_CATEGORIES.LAB_TEST_PANEL,
                sourceRecordId: labTestPanelRequest.labTestPanelId
            }
        });
        if (labTestPanelProduct) {
            return; // There's a product for the panel, so no need to create invoice items for the individual tests
        }
    }
    const testProduct = await instance.sequelize.models.InvoiceProduct.findOne({
        where: {
            category: _constants.INVOICE_ITEMS_CATEGORIES.LAB_TEST_TYPE,
            sourceRecordId: instance.labTestTypeId
        }
    });
    if (!testProduct) {
        return;
    }
    await instance.sequelize.models.Invoice.addItemToInvoice(instance, labRequest.encounterId, testProduct, labRequest.requestedById);
};
const afterCreateHook = async (instance)=>{
    await addToInvoiceAfterCreateHook(instance);
};

//# sourceMappingURL=hooks.js.map