"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "LabTestPanelLabTestTypes", {
    enumerable: true,
    get: function() {
        return LabTestPanelLabTestTypes;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let LabTestPanelLabTestTypes = class LabTestPanelLabTestTypes extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            order: {
                type: _sequelize.DataTypes.INTEGER,
                allowNull: false,
                defaultValue: 0
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.LabTestPanel, {
            foreignKey: 'labTestPanelId',
            as: 'labTestPanel'
        });
        this.belongsTo(models.LabTestType, {
            foreignKey: 'labTestTypeId',
            as: 'labTestType'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=LabTestPanelLabTestTypes.js.map