"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "LabTestPanelRequest", {
    enumerable: true,
    get: function() {
        return LabTestPanelRequest;
    }
});
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildEncounterLinkedSyncFilter = require("../sync/buildEncounterLinkedSyncFilter");
const _buildEncounterLinkedLookupFilter = require("../sync/buildEncounterLinkedLookupFilter");
let LabTestPanelRequest = class LabTestPanelRequest extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Encounter, {
            foreignKey: 'encounterId',
            as: 'encounter'
        });
        this.belongsTo(models.LabTestPanel, {
            foreignKey: 'labTestPanelId',
            as: 'labTestPanel'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable, sessionConfig) {
        if (sessionConfig.syncAllLabRequests) {
            return ''; // include all lab panel requests
        }
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupSelect)(this, {
                isLabRequestValue: 'TRUE'
            }),
            joins: (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupJoins)(this)
        };
    }
};

//# sourceMappingURL=LabTestPanelRequest.js.map