"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "LocationGroup", {
    enumerable: true,
    get: function() {
        return LocationGroup;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _errors = require("@tamanu/errors");
const _Model = require("./Model");
let LocationGroup = class LocationGroup extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            code: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            name: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            visibilityStatus: {
                type: _sequelize.DataTypes.TEXT,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
            },
            isBookable: {
                type: _sequelize.DataTypes.STRING,
                defaultValue: _constants.LOCATION_BOOKABLE_VIEW.NO
            }
        }, {
            ...options,
            validate: {
                mustHaveFacility () {
                    if (!this.deletedAt && !this.facilityId) {
                        throw new _errors.InvalidOperationError('A location group must have a facility.');
                    }
                },
                mustNotIncludeComma () {
                    if (this.name.includes(',')) {
                        throw new _errors.InvalidOperationError('A location group name cannot include a comma.');
                    }
                }
            },
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
            indexes: [
                {
                    unique: true,
                    fields: [
                        'code'
                    ]
                }
            ]
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Facility, {
            foreignKey: 'facilityId',
            as: 'facility'
        });
        this.hasMany(models.Location, {
            foreignKey: 'locationGroupId'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=LocationGroup.js.map