import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
export declare class MedicationDispense extends Model {
    id: string;
    pharmacyOrderPrescriptionId: string;
    quantity: number;
    instructions?: string;
    dispensedByUserId: string;
    dispensedAt: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static getListReferenceAssociations(): string[];
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
}
//# sourceMappingURL=MedicationDispense.d.ts.map