"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ProcedureTypeSurvey", {
    enumerable: true,
    get: function() {
        return ProcedureTypeSurvey;
    }
});
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _sequelize = require("sequelize");
let ProcedureTypeSurvey = class ProcedureTypeSurvey extends _Model.Model {
    static initModel(options) {
        super.init({
            id: {
                type: _sequelize.DataTypes.UUID,
                allowNull: false,
                primaryKey: true,
                defaultValue: _sequelize.Sequelize.fn('gen_random_uuid')
            },
            procedureTypeId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            surveyId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
            uniqueKeys: {
                procedure_type_survey_unique: {
                    fields: [
                        'procedure_type_id',
                        'survey_id'
                    ]
                }
            }
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'procedureTypeId',
            as: 'procedureType'
        });
        this.belongsTo(models.Survey, {
            foreignKey: 'surveyId',
            as: 'survey'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=ProcedureTypeSurvey.js.map