"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ProgramRegistryConditionCategory", {
    enumerable: true,
    get: function() {
        return ProgramRegistryConditionCategory;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let ProgramRegistryConditionCategory = class ProgramRegistryConditionCategory extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            code: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            name: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            visibilityStatus: {
                type: _sequelize.DataTypes.TEXT,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ProgramRegistry, {
            foreignKey: {
                name: 'programRegistryId',
                allowNull: false
            },
            as: 'programRegistry'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=ProgramRegistryConditionCategory.js.map