"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ReferenceDrug", {
    enumerable: true,
    get: function() {
        return ReferenceDrug;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let ReferenceDrug = class ReferenceDrug extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            referenceDataId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false,
                unique: true,
                references: {
                    model: 'referenceData',
                    key: 'id'
                }
            },
            route: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            },
            units: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            },
            notes: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            },
            isSensitive: {
                type: _sequelize.DataTypes.BOOLEAN,
                allowNull: false,
                defaultValue: false
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'referenceDataId',
            as: 'referenceData'
        });
        this.hasMany(models.ReferenceDrugFacility, {
            foreignKey: 'referenceDrugId',
            as: 'facilities'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
    static getFullReferenceAssociations() {
        return [
            'referenceData'
        ];
    }
    /**
   * Check if any medications in the given list are sensitive
   * @param medicationIds - Array of medication IDs to check
   * @returns Promise<boolean> - True if any medication is sensitive, false otherwise
   */ static async hasSensitiveMedication(medicationIds) {
        if (!medicationIds || medicationIds.length === 0) {
            return false;
        }
        const { ReferenceData } = this.sequelize.models;
        const sensitiveMedication = await ReferenceData.findOne({
            where: {
                id: {
                    [_sequelize.Op.in]: medicationIds
                },
                type: _constants.REFERENCE_TYPES.DRUG
            },
            include: {
                model: this,
                as: 'referenceDrug',
                attributes: [
                    'isSensitive'
                ],
                where: {
                    isSensitive: true
                },
                required: true
            },
            attributes: [
                'id'
            ]
        });
        return !!sensitiveMedication;
    }
};

//# sourceMappingURL=ReferenceDrug.js.map