"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "UserLeave", {
    enumerable: true,
    get: function() {
        return UserLeave;
    }
});
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _model = require("../types/model");
let UserLeave = class UserLeave extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            startDate: (0, _model.dateType)('startDate', {
                allowNull: false
            }),
            endDate: (0, _model.dateType)('endDate', {
                allowNull: false
            })
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: 'userId',
            as: 'user'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=UserLeave.js.map