"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirPatient", {
    enumerable: true,
    get: function() {
        return FhirPatient;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _fhirTypes = require("@tamanu/shared/services/fhirTypes");
const _Resource = require("./Resource");
const _Patient = require("../../utils/fhir/Patient");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let FhirPatient = class FhirPatient extends _Resource.FhirResource {
    static initModel(options, models) {
        super.initResource({
            extension: _sequelize.DataTypes.JSONB,
            identifier: _sequelize.DataTypes.JSONB,
            active: {
                type: _sequelize.DataTypes.BOOLEAN,
                allowNull: false,
                defaultValue: true
            },
            name: _sequelize.DataTypes.JSONB,
            telecom: _sequelize.DataTypes.JSONB,
            gender: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            birthDate: _sequelize.DataTypes.TEXT,
            deceasedDateTime: _sequelize.DataTypes.TEXT,
            address: _sequelize.DataTypes.JSONB,
            link: _sequelize.DataTypes.JSONB
        }, options);
        this.UpstreamModels = [
            models.Patient
        ];
        this.upstreams = [
            models.Patient,
            models.PatientAdditionalData
        ];
        this.referencedResources = [];
    }
    async updateMaterialisation() {
        const upstream = await this.getUpstream((0, _Patient.getQueryOptions)(this.sequelize.models));
        const values = await (0, _Patient.getValues)(upstream, this.sequelize.models);
        this.set(values);
    }
    async getRelatedUpstreamIds() {
        const upstream = await this.getUpstream();
        const mergedUp = await upstream?.getMergedUp();
        const mergedDown = await upstream?.getMergedDown();
        return [
            ...mergedUp?.map((u)=>u.id) || [],
            ...mergedDown?.map((u)=>u.id) || []
        ];
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id, deletedRow = null) {
        const { Patient } = this.sequelize.models;
        if (upstreamTable === Patient.tableName) {
            return (0, _Patient.fromPatients)(this.sequelize.models, table, id, deletedRow);
        }
        return null;
    }
    asFhir() {
        const resource = super.asFhir();
        const { FhirPatient } = this.sequelize.models;
        // Exclude upstream links if they remain in the materialised data.
        // This can occur if there are records in the Tamanu data that have not been
        // materialised into the FHIR data, but are referred to by the patient links.
        // Although that should not really happen, but it's better to be safe and not
        // expose the upstream link data.
        resource.link = resource.link.filter((link)=>link.other.type !== _fhirTypes.FhirReference.unresolvedReferenceType(FhirPatient));
        return resource;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ..._Patient.searchParameters
        };
    }
};
_define_property(FhirPatient, "CAN_DO", new Set([
    _constants.FHIR_INTERACTIONS.INSTANCE.READ,
    _constants.FHIR_INTERACTIONS.TYPE.SEARCH,
    _constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE
]));

//# sourceMappingURL=FhirPatient.js.map