import { FhirResource } from './Resource';
import type { InitOptions, Models } from '../../types/model';
export declare class FhirPractitioner extends FhirResource {
    name?: Record<string, any>;
    identifier?: Record<string, any>;
    telecom?: Record<string, any>;
    static initModel(options: InitOptions, models: Models): void;
    static CAN_DO: Set<string>;
    updateMaterialisation(): Promise<void>;
    static queryToFindUpstreamIdsFromTable(upstreamTable: string, table: string, id: string): Promise<{
        where: {
            id: string;
        };
    } | null>;
    static searchParameters(): {
        identifier: {
            type: string;
            path: string[][];
            tokenType: string;
        };
        telecom: {
            type: string;
            path: string[][];
            tokenType: string;
        };
    };
}
//# sourceMappingURL=FhirPractitioner.d.ts.map