import { Model } from '../Model';
import type { InitOptions } from '../../types/model';
export declare class FhirJob extends Model {
    id: string;
    priority: number;
    status: string;
    worker_id?: string;
    started_at?: Date;
    completed_at?: Date;
    errored_at?: Date;
    error?: string;
    topic: string;
    discriminant: string;
    payload: Record<string, any>;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static backlogUntilLimit(topic: string, limit: number, includeDropped?: boolean): Promise<unknown>;
    static grab(workerId: string, topic: string): Promise<FhirJob | null>;
    static submit(topic: string, payload?: {}, { priority, discriminant }?: {
        priority?: number | undefined;
        discriminant?: null | undefined;
    }): Promise<string | undefined>;
    start(workerId: string): Promise<void>;
    complete(workerId: string): Promise<void>;
    fail(workerId: string, error: string): Promise<this>;
}
//# sourceMappingURL=Job.d.ts.map