import { FhirResource } from './Resource';
import type { InitOptions, Models } from '../../types/model';
export declare class MediciReport extends FhirResource {
    patientId: string;
    firstName: string;
    lastName: string;
    dateOfBirth?: string;
    sex: string;
    patientBillingId?: string;
    patientBillingType?: string;
    encounterId: string;
    age?: number;
    encounterStartDate: string;
    encounterEndDate?: string;
    dischargeDate?: string;
    encounterType?: Record<string, any>;
    weight?: number;
    visitType: string;
    triageCategory?: string;
    episodeEndStatus?: Record<string, any>;
    encounterDischargeDisposition?: Record<string, any>;
    waitTime?: string;
    departments?: Record<string, any>;
    locations?: Record<string, any>;
    reasonForEncounter?: string;
    diagnoses?: Record<string, any>;
    medications?: Record<string, any>;
    vaccinations?: Record<string, any>;
    procedures?: Record<string, any>;
    labRequests?: Record<string, any>;
    imagingRequests?: Record<string, any>;
    notes?: Record<string, any>;
    static initModel(options: InitOptions, models: Models): void;
    static get fhirName(): string;
    static CAN_DO: Set<string>;
    updateMaterialisation(): Promise<void>;
    static queryToFilterUpstream(upstreamTable: string): Promise<{
        where: {
            endDate: {
                [x: symbol]: null;
            };
        };
    } | null>;
    static queryToFindUpstreamIdsFromTable(upstreamTable: string, table: string, id: string, deletedRow?: null): Promise<{
        where: {
            id: string;
        };
        include?: undefined;
    } | {
        include: {
            model: typeof import("..").EncounterHistory;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").ImagingRequest;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").ImagingRequest;
            as: string;
            required: boolean;
            include: {
                model: typeof import("..").ImagingRequestArea;
                required: boolean;
                where: {
                    id: string;
                };
            }[];
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").LabRequest;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").LabRequest;
            as: string;
            required: boolean;
            include: {
                model: typeof import("..").LabTest;
                as: string;
                required: boolean;
                where: {
                    id: string;
                };
            }[];
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").LabRequest;
            as: string;
            required: boolean;
            include: {
                model: typeof import("..").LabTest;
                as: string;
                required: boolean;
                include: {
                    model: typeof import("..").LabTestType;
                    as: string;
                    required: boolean;
                    where: {
                        id: string;
                    };
                }[];
            }[];
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").AdministeredVaccine;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").AdministeredVaccine;
            as: string;
            required: boolean;
            include: {
                model: typeof import("..").ScheduledVaccine;
                as: string;
                required: boolean;
                where: {
                    id: string;
                };
            }[];
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").EncounterDiagnosis;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").Prescription;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").Procedure;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").Triage;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").Note;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").Discharge;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").Patient;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").Patient;
            as: string;
            required: boolean;
            include: {
                model: typeof import("..").PatientBirthData;
                as: string;
                required: boolean;
                where: {
                    id: string;
                };
            }[];
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").Location;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").Location;
            as: string;
            required: boolean;
            include: {
                model: typeof import("..").LocationGroup;
                as: string;
                required: boolean;
                where: {
                    id: string;
                };
            }[];
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").Department;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | null>;
}
//# sourceMappingURL=MediciReport.d.ts.map