"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "MediciReport", {
    enumerable: true,
    get: function() {
        return MediciReport;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Resource = require("./Resource");
const _MediciReport = require("../../utils/fhir/MediciReport");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let MediciReport = class MediciReport extends _Resource.FhirResource {
    static initModel(options, models) {
        super.initResource({
            patientId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            firstName: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            lastName: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            dateOfBirth: _sequelize.DataTypes.STRING,
            sex: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            patientBillingId: _sequelize.DataTypes.STRING,
            patientBillingType: _sequelize.DataTypes.TEXT,
            encounterId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            age: _sequelize.DataTypes.INTEGER,
            encounterStartDate: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            encounterEndDate: _sequelize.DataTypes.STRING,
            dischargeDate: _sequelize.DataTypes.STRING,
            encounterType: _sequelize.DataTypes.JSONB,
            weight: _sequelize.DataTypes.DECIMAL,
            visitType: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            triageCategory: _sequelize.DataTypes.TEXT,
            episodeEndStatus: _sequelize.DataTypes.JSONB,
            encounterDischargeDisposition: _sequelize.DataTypes.JSONB,
            waitTime: _sequelize.DataTypes.STRING,
            departments: _sequelize.DataTypes.JSONB,
            locations: _sequelize.DataTypes.JSONB,
            reasonForEncounter: _sequelize.DataTypes.TEXT,
            diagnoses: _sequelize.DataTypes.JSONB,
            medications: _sequelize.DataTypes.JSONB,
            vaccinations: _sequelize.DataTypes.JSONB,
            procedures: _sequelize.DataTypes.JSONB,
            labRequests: _sequelize.DataTypes.JSONB,
            imagingRequests: _sequelize.DataTypes.JSONB,
            notes: _sequelize.DataTypes.JSONB
        }, {
            ...options,
            tableName: 'non_fhir_medici_report'
        });
        this.UpstreamModels = [
            models.Encounter
        ];
        this.upstreams = [
            models.Patient,
            models.PatientBirthData,
            models.ImagingRequest,
            models.ImagingRequestArea,
            models.Encounter,
            models.EncounterHistory,
            models.LabRequest,
            models.LabTest,
            models.LabTestType,
            models.AdministeredVaccine,
            models.ScheduledVaccine,
            models.Discharge,
            models.EncounterDiagnosis,
            models.Prescription,
            models.Procedure,
            models.Triage,
            models.Note,
            models.Department,
            models.Location,
            models.LocationGroup
        ];
    }
    static get fhirName() {
        return this.name; // this is not FHIR
    }
    async updateMaterialisation() {
        const materialisedValues = await (0, _MediciReport.getMaterialisedValues)(this.sequelize, this.upstreamId);
        this.set({
            ...materialisedValues,
            resolved: true
        });
    }
    static async queryToFilterUpstream(upstreamTable) {
        const { Encounter } = this.sequelize.models;
        if (upstreamTable === Encounter.tableName) {
            return (0, _MediciReport.filterFromEncounters)(this.sequelize.models, upstreamTable);
        }
        return null;
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id, deletedRow = null) {
        const { Encounter } = this.sequelize.models;
        if (upstreamTable === Encounter.tableName) {
            return (0, _MediciReport.fromEncounters)(this.sequelize.models, table, id, deletedRow);
        }
        return null;
    }
};
_define_property(MediciReport, "CAN_DO", new Set([
    _constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE
]));

//# sourceMappingURL=MediciReport.js.map