import { type JoinConfig } from './buildEncounterLinkedSyncFilter';
import type { Model } from '../models/Model';
/**
 * Helper to determine if a facility_id should be populated in sync lookup
 * Only populates facility_id when the encounter is from a sensitive facility
 * This ensures sensitive encounters are only synced to their originating facility
 */
export declare const ADD_SENSITIVE_FACILITY_ID_IF_APPLICABLE = "\n    CASE\n      WHEN facilities.is_sensitive = TRUE THEN facilities.id\n      ELSE NULL\n    END\n  ";
export declare function buildEncounterLinkedLookupSelect(model: typeof Model, extraSelects?: Record<string, string>): Promise<string>;
export declare function buildEncounterLinkedLookupJoins(model: typeof Model, joinsToEncounters?: JoinConfig[]): string;
export declare function buildEncounterLinkedLookupFilter(model: typeof Model): Promise<{
    select: string;
    joins: string;
}>;
//# sourceMappingURL=buildEncounterLinkedLookupFilter.d.ts.map