"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    attachAuditUserToDbSession: function() {
        return attachAuditUserToDbSession;
    },
    getAuditUserId: function() {
        return getAuditUserId;
    }
});
const _async_hooks = require("async_hooks");
const auditUserIdAsyncLocalStorage = new _async_hooks.AsyncLocalStorage();
const getAuditUserId = ()=>auditUserIdAsyncLocalStorage.getStore();
const attachAuditUserToDbSession = async (req, _res, next)=>{
    auditUserIdAsyncLocalStorage.run(req.user?.id, next);
};

//# sourceMappingURL=attachAuditUserToDbSession.js.map