"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getQueryOptions", {
    enumerable: true,
    get: function() {
        return getQueryOptions;
    }
});
function getQueryOptions(models) {
    const { ScheduledVaccine, Encounter, Patient, ReferenceData, User, AdministeredVaccine } = models;
    const administeredVaccineOptions = {
        include: [
            {
                model: User,
                as: 'recorder'
            },
            {
                model: ScheduledVaccine,
                as: 'scheduledVaccine',
                include: [
                    {
                        model: ReferenceData,
                        as: 'vaccine'
                    }
                ]
            },
            {
                model: Encounter,
                as: 'encounter',
                include: [
                    {
                        model: Patient,
                        as: 'patient'
                    }
                ]
            }
        ]
    };
    return {
        [AdministeredVaccine.tableName]: administeredVaccineOptions
    };
}

//# sourceMappingURL=getQueryOptions.js.map