import { FhirAnnotation, FhirCodeableConcept, FhirIdentifier, FhirReference } from '@tamanu/shared/services/fhirTypes';
import type { Models } from '../../../types/model';
import type { Model } from '../../../models/Model';
export declare function getValues(upstream: Model, models: Models): Promise<{
    lastUpdated: Date;
    identifier: FhirIdentifier[];
    status: string;
    intent: string;
    category: FhirCodeableConcept[];
    priority: string | null;
    code: FhirCodeableConcept | null;
    orderDetail: FhirCodeableConcept[];
    subject: FhirReference;
    encounter: FhirReference;
    occurrenceDateTime: any;
    requester: FhirReference;
    locationCode: FhirCodeableConcept[];
    note: any;
    resolved: boolean;
} | {
    lastUpdated: Date;
    identifier: FhirIdentifier[];
    status: string;
    intent: string;
    category: FhirCodeableConcept[];
    priority: string | null;
    code: FhirCodeableConcept | null;
    orderDetail: (FhirCodeableConcept | null)[];
    subject: FhirReference;
    encounter: FhirReference;
    occurrenceDateTime: any;
    requester: FhirReference;
    note: FhirAnnotation[];
    specimen: FhirReference[] | null;
    resolved: boolean;
}>;
export declare function getIsLive(upstream: Model, models: Models): boolean;
export declare function shouldForceRematerialise(upstream: Model, downstream: {
    status: string;
} & Model, models: Models): boolean;
//# sourceMappingURL=getValues.d.ts.map