const Sequelize = require('sequelize');
export default {
    up: async (query)=>{
        await query.createTable('document_metadata', {
            id: {
                type: Sequelize.STRING,
                defaultValue: Sequelize.UUIDV4,
                allowNull: false,
                primaryKey: true
            },
            name: {
                type: Sequelize.STRING,
                allowNull: false
            },
            type: {
                type: Sequelize.STRING,
                allowNull: false
            },
            created_date: {
                type: Sequelize.DATE,
                allowNull: true
            },
            uploaded_date: {
                type: Sequelize.DATE,
                allowNull: false
            },
            owner_id: {
                type: Sequelize.STRING,
                references: {
                    model: 'users',
                    key: 'id'
                },
                allowNull: false
            },
            patient_id: {
                type: Sequelize.STRING,
                references: {
                    model: 'patients',
                    key: 'id'
                },
                allowNull: true
            },
            encounter_id: {
                type: Sequelize.STRING,
                references: {
                    model: 'encounters',
                    key: 'id'
                },
                allowNull: true
            },
            attachment_id: {
                type: Sequelize.STRING,
                references: {
                    model: 'attachments',
                    key: 'id'
                },
                allowNull: false
            },
            marked_for_push: {
                type: Sequelize.BOOLEAN,
                allowNull: false,
                defaultValue: true
            },
            is_pushing: {
                type: Sequelize.BOOLEAN,
                allowNull: false,
                defaultValue: false
            },
            pushed_at: {
                type: Sequelize.DATE,
                allowNull: true
            },
            pulled_at: {
                type: Sequelize.DATE,
                allowNull: true
            },
            created_at: {
                type: Sequelize.DATE,
                defaultValue: Sequelize.NOW
            },
            updated_at: {
                type: Sequelize.DATE,
                defaultValue: Sequelize.NOW
            },
            deleted_at: {
                type: Sequelize.DATE,
                defaultValue: Sequelize.NOW
            }
        });
    },
    down: async (query)=>{
        await query.dropTable('document_metadata');
    }
};

//# sourceMappingURL=051_addDocumentMetadataTable.js.map