export async function up(query) {
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION local_system_fact(the_key text, the_default text)
    RETURNS text
    LANGUAGE plpgsql STABLE PARALLEL SAFE STRICT AS $$
      DECLARE
        the_value text;
      BEGIN
        SELECT value INTO the_value
        FROM local_system_facts WHERE key = the_key;
        IF NOT FOUND THEN
          the_value := the_default;
        END IF;
        RETURN the_value;
      END;
    $$ 
  `);
}
export async function down(query) {
    await query.sequelize.query('DROP FUNCTION local_system_fact CASCADE');
}

//# sourceMappingURL=1739968205100-addLSFFunction.js.map