import { DataTypes } from 'sequelize';
export async function up(query) {
    await query.removeColumn('invoice_price_list_items', 'visibility_status');
    await query.addColumn('invoice_price_list_items', 'is_hidden', {
        type: DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false
    });
}
export async function down(query) {
    await query.addColumn('invoice_price_list_items', 'visibility_status', {
        type: DataTypes.TEXT,
        allowNull: false,
        defaultValue: 'current'
    });
    await query.removeColumn('invoice_price_list_items', 'is_hidden');
}

//# sourceMappingURL=1765142814817-updateInvoicePriceListItemColumns.js.map