import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from '../Model';
import { buildEncounterLinkedSyncFilter } from '../../sync/buildEncounterLinkedSyncFilter';
import { buildEncounterLinkedLookupJoins, buildEncounterLinkedLookupSelect } from '../../sync/buildEncounterLinkedLookupFilter';
import { afterCreateHook, afterUpdateHook } from './hooks';
export class ImagingRequestArea extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL,
            hooks: {
                afterCreate: afterCreateHook,
                afterUpdate: afterUpdateHook
            }
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ImagingRequest, {
            foreignKey: 'imagingRequestId',
            as: 'imagingRequest'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'areaId',
            as: 'area'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return buildEncounterLinkedSyncFilter([
            this.tableName,
            'imaging_requests',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await buildEncounterLinkedLookupSelect(this),
            joins: buildEncounterLinkedLookupJoins(this, [
                'imaging_requests',
                'encounters'
            ])
        };
    }
}

//# sourceMappingURL=ImagingRequestArea.js.map