import { Model } from '../Model';
import { type InitOptions, type Models } from '../../types/model';
export declare class InvoiceItem extends Model {
    id: string;
    orderDate: string;
    productId?: string;
    quantity: number;
    note?: string;
    approved: boolean;
    sourceRecordType?: string;
    sourceRecordId?: string;
    productNameFinal?: string;
    manualEntryPrice?: number;
    priceFinal?: number;
    productCodeFinal?: string;
    invoiceId?: string;
    orderedByUserId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
    static getListReferenceAssociations(models: Models, invoicePriceListId?: string, tableAlias?: string): ({
        model: typeof import("./InvoiceProduct").InvoiceProduct;
        as: string;
        include: Record<string, any>[];
        attributes?: undefined;
    } | {
        model: typeof import("..").User;
        as: string;
        attributes: string[];
        include?: undefined;
    } | {
        model: typeof import("./InvoiceItemDiscount").InvoiceItemDiscount;
        as: string;
        include?: undefined;
        attributes?: undefined;
    } | {
        model: typeof import("./InvoiceItemFinalisedInsurance").InvoiceItemFinalisedInsurance;
        as: string;
        include?: undefined;
        attributes?: undefined;
    })[];
}
//# sourceMappingURL=InvoiceItem.d.ts.map