import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from '../Model';
import { buildEncounterLinkedLookupJoins, buildEncounterLinkedLookupSelect, buildEncounterLinkedSyncFilter } from '../../sync';
export class InvoiceItemFinalisedInsurance extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            invoiceItemId: {
                type: DataTypes.UUID,
                allowNull: false
            },
            coverageValueFinal: {
                type: DataTypes.DECIMAL,
                allowNull: false
            },
            invoiceInsurancePlanId: {
                type: DataTypes.STRING,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL,
            indexes: [
                {
                    fields: [
                        'invoiceInsurancePlanId'
                    ]
                },
                {
                    unique: true,
                    fields: [
                        'invoiceItemId',
                        'invoiceInsurancePlanId'
                    ]
                }
            ]
        });
    }
    static initRelations(models) {
        this.belongsTo(models.InvoiceItem, {
            foreignKey: 'invoiceItemId',
            as: 'invoiceItem'
        });
        this.belongsTo(models.InvoiceInsurancePlan, {
            foreignKey: 'invoiceInsurancePlanId',
            as: 'invoiceInsurancePlan'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return buildEncounterLinkedSyncFilter([
            this.tableName,
            'invoice_items',
            'invoices',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await buildEncounterLinkedLookupSelect(this),
            joins: buildEncounterLinkedLookupJoins(this, [
                'invoice_items',
                'invoices',
                'encounters'
            ])
        };
    }
}

//# sourceMappingURL=InvoiceItemFinalisedInsurance.js.map