import { Model } from '../../models/Model';
import { type InitOptions, type Models } from '../../types/model';
import type { SessionConfig } from '../../types/sync';
import type { LabTestType } from '../../models/LabTestType';
export declare class LabTest extends Model {
    id: string;
    date: string;
    result: string;
    laboratoryOfficer?: string;
    verification?: string;
    completedDate?: string;
    labRequestId?: string;
    categoryId?: string;
    labTestMethodId?: string;
    labTestTypeId?: string;
    labTestType?: LabTestType;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static getListReferenceAssociations(): string[];
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string, sessionConfig: SessionConfig): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
}
//# sourceMappingURL=LabTest.d.ts.map