import { Model } from './Model';
import { buildPatientSyncFilterViaPatientId } from '../sync/buildPatientSyncFilterViaPatientId';
import { type InitOptions, type Models } from '../types/model';
export declare class PatientBirthData extends Model {
    id: string;
    patientId: string;
    birthWeight?: number;
    birthLength?: number;
    birthDeliveryType?: string;
    attendantAtBirth?: string;
    nameOfAttendantAtBirth?: string;
    gestationalAgeEstimate?: number;
    apgarScoreOneMinute?: number;
    apgarScoreFiveMinutes?: number;
    apgarScoreTenMinutes?: number;
    timeOfBirth?: string;
    birthType?: string;
    registeredBirthPlace?: string;
    birthFacilityId?: string;
    static initModel(options: InitOptions): void;
    static initRelations(models: Models): void;
    static nonMetadataColumns: string[];
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
    }>;
    static buildPatientSyncFilter: typeof buildPatientSyncFilterViaPatientId;
}
//# sourceMappingURL=PatientBirthData.d.ts.map