function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { getCurrentDateTimeString } from '@tamanu/utils/dateTime';
import { Model } from './Model';
import { buildPatientSyncFilterViaPatientId } from '../sync/buildPatientSyncFilterViaPatientId';
import { buildPatientLinkedLookupFilter } from '../sync/buildPatientLinkedLookupFilter';
import { dateTimeType } from '../types/model';
export class PatientCondition extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            note: DataTypes.STRING,
            recordedDate: dateTimeType('recordedDate', {
                defaultValue: getCurrentDateTimeString,
                allowNull: false
            }),
            resolved: {
                type: DataTypes.BOOLEAN,
                defaultValue: false
            },
            resolutionDate: dateTimeType('resolutionDate', {
                defaultValue: getCurrentDateTimeString,
                allowNull: true
            }),
            resolutionNote: DataTypes.TEXT
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'conditionId',
            as: 'condition'
        });
        this.belongsTo(models.User, {
            foreignKey: 'examinerId'
        });
        this.belongsTo(models.User, {
            foreignKey: 'resolutionPractitionerId'
        });
    }
    static getListReferenceAssociations() {
        return [
            'condition'
        ];
    }
    static async buildSyncLookupQueryDetails() {
        return buildPatientLinkedLookupFilter(this);
    }
}
_define_property(PatientCondition, "buildPatientSyncFilter", buildPatientSyncFilterViaPatientId);

//# sourceMappingURL=PatientCondition.js.map