import { Model } from './Model';
import { type InitOptions } from '../types/model';
export declare class SyncSession extends Model {
    id: string;
    startTime?: Date;
    lastConnectionTime?: Date;
    snapshotStartedAt?: Date;
    snapshotCompletedAt?: Date;
    persistCompletedAt?: Date;
    completedAt?: Date;
    startedAtTick?: number;
    pullSince?: number;
    pullUntil?: number;
    errors?: string;
    debugInfo?: Record<string, object>;
    parameters?: Record<string, object>;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    /**
     * Set business-logic parameters to the sync session.
     * As this writes to the table, it may contend locks.
     * For debugging information, use addDebugInfo() instead.
     */
    static setParameters(id: string, params: {
        [key: string]: any;
    }): Promise<void>;
    /**
     * Add information useful for debugging sync to the session.
     * To avoid contending locks, this will drop the data if it
     * can't obtain the write. For business-logic parameters, use
     * setParameters() instead.
     */
    static addDebugInfo(id: string, info: {
        [key: string]: any;
    }): Promise<void>;
    /**
     * @param {number} tick sync tick
     */
    markAsStartedAt(tick: number): Promise<[affectedCount: number]>;
    markErrored(error: string): Promise<void>;
    static markSessionErrored(id: string, error: string): Promise<void>;
}
//# sourceMappingURL=SyncSession.d.ts.map