import { FhirResource } from './Resource';
import type { InitOptions, Models } from '../../types/model';
export declare class FhirImmunization extends FhirResource {
    status: string;
    vaccineCode: Record<string, any>;
    patient: Record<string, any>;
    encounter?: Record<string, any>;
    occurrenceDateTime?: string;
    lotNumber?: string;
    site?: Record<string, any>;
    performer?: Record<string, any>;
    protocolApplied?: Record<string, any>;
    static initModel(options: InitOptions, models: Models): void;
    static CAN_DO: Set<string>;
    updateMaterialisation(): Promise<void>;
    static queryToFindUpstreamIdsFromTable(upstreamTable: string, table: string, id: string): Promise<{
        where: {
            id: string;
        };
        include?: undefined;
    } | {
        include: {
            model: typeof import("..").Encounter;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").Encounter;
            as: string;
            required: boolean;
            include: {
                model: typeof import("..").Patient;
                as: string;
                required: boolean;
                where: {
                    id: string;
                };
            }[];
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").ScheduledVaccine;
            as: string;
            required: boolean;
            include: {
                model: typeof import("..").ReferenceData;
                as: string;
                required: boolean;
                where: {
                    id: string;
                };
            }[];
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").ScheduledVaccine;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").User;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | null>;
    static searchParameters(): {
        patient: {
            type: string;
            path: string[][];
            referenceTypes: string[];
        };
        'vaccine-code': {
            type: string;
            path: string[][];
            tokenType: string;
        };
    };
}
//# sourceMappingURL=FhirImmunization.d.ts.map