import { Model } from '../models/Model';
/**
 * Creates helper functions for recording model changes in update methods.
 * These functions track changes to model fields and generate system note messages.
 *
 * @param modelInstance - The model instance being updated (this)
 * @param updateData - The data object containing the new values
 * @param systemNoteRows - Array to collect system note messages
 * @param changeTypes - Optional array to collect change types for history tracking (soon to be deprecated)
 * @returns Object containing recordForeignKeyChange and recordTextColumnChange functions
 */
export declare function createChangeRecorders<T extends Model>(modelInstance: T, updateData: Partial<T>, systemNoteRows: string[], changeTypes?: string[]): {
    onChangeForeignKey: ({ columnName, noteLabel, model, sequelizeOptions, accessor, changeType, onChange, }: {
        columnName: keyof T;
        noteLabel: string;
        model: typeof Model;
        sequelizeOptions?: any;
        accessor?: (record: any) => string;
        changeType?: string;
        onChange?: () => Promise<void>;
    }) => Promise<void>;
    onChangeTextColumn: ({ columnName, noteLabel, formatText, changeType, onChange, }: {
        columnName: keyof T;
        noteLabel: string;
        formatText?: (value: any) => string;
        changeType?: string;
        onChange?: () => Promise<void>;
    }) => Promise<void>;
};
//# sourceMappingURL=recordModelChanges.d.ts.map