"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getCaseInsensitiveFilter: function() {
        return getCaseInsensitiveFilter;
    },
    getOrderClause: function() {
        return getOrderClause;
    },
    getTextToBooleanFilter: function() {
        return getTextToBooleanFilter;
    },
    mapQueryFilters: function() {
        return mapQueryFilters;
    }
});
const _sequelize = require("sequelize");
const getOrderClause = (order, orderBy)=>{
    const nestedAttributes = orderBy.split('.');
    return [
        [
            ...nestedAttributes,
            order.toUpperCase()
        ]
    ];
};
const mapQueryFilters = (params, options)=>{
    // Helper function used as the default mapFn
    const defaultFilter = (fieldName, operator, value)=>{
        return {
            [fieldName]: {
                [operator]: value
            }
        };
    };
    const queryFilters = [];
    // Go through each filter option
    options.forEach(({ key, alias, operator, mapFn = defaultFilter })=>{
        // Extract search parameter value
        const value = params[key];
        // Extract specified keys without undefined or null values
        if (value !== null && value !== undefined) {
            // Map key to specified alias or default to key
            const newKey = alias || key;
            // Add new filter
            queryFilters.push(mapFn(newKey, operator, value));
        }
    });
    if (queryFilters.length > 0) {
        return {
            [_sequelize.Op.and]: queryFilters
        };
    }
    return {};
};
const getCaseInsensitiveFilter = (fields)=>{
    return (fieldName, operator, value)=>{
        const columnName = fields[fieldName];
        const filterValue = _sequelize.Sequelize.where(_sequelize.Sequelize.fn('upper', _sequelize.Sequelize.col(columnName)), {
            [operator]: value.toUpperCase()
        });
        return {
            [fieldName]: filterValue
        };
    };
};
const getTextToBooleanFilter = (trueString)=>{
    return (fieldName, operator, value)=>({
            [fieldName]: {
                [operator]: value === trueString
            }
        });
};

//# sourceMappingURL=utils.js.map