// serverInfo must be imported before any shared modules
// so that it can set globals
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
const _serverInfo = require("./serverInfo");
const _commander = require("commander");
const _logging = require("@tamanu/shared/services/logging");
const _subCommands = require("./subCommands");
async function run() {
    _commander.program.version(_serverInfo.version).description('Tamanu Facility server').name('node dist');
    _commander.program.addCommand(_subCommands.startAllCommand, {
        isDefault: true
    });
    _commander.program.addCommand(_subCommands.startApiCommand);
    _commander.program.addCommand(_subCommands.startSyncCommand);
    _commander.program.addCommand(_subCommands.startTasksCommand);
    _commander.program.addCommand(_subCommands.reportCommand);
    _commander.program.addCommand(_subCommands.syncCommand);
    _commander.program.addCommand(_subCommands.migrateCommand);
    _commander.program.addCommand(_subCommands.migrateAppointmentsToLocationGroupsCommand);
    _commander.program.addCommand(_subCommands.shellCommand);
    _commander.program.addCommand(_subCommands.upgradeCommand);
    await _commander.program.parseAsync(process.argv);
}
// catch and exit if run() throws an error
(async ()=>{
    try {
        await run();
    } catch (e) {
        _logging.log.error(`run(): fatal error: ${e.toString()}`);
        _logging.log.error(e.stack);
        process.exit(1);
    }
})();

//# sourceMappingURL=index.js.map