"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return errorHandler;
    }
});
const _database = require("@tamanu/database");
const _utils = require("@tamanu/shared/utils");
function errorHandler(error, req, res, next) {
    // see https://expressjs.com/en/guide/error-handling.html#the-default-error-handler
    if (res.headersSent) {
        next(error);
        return;
    }
    const { problem, json } = (0, _utils.errorHandlerProblem)(error, req, {
        convertDatabaseError: _database.convertDatabaseError
    });
    // we're past the point of permission checking; this just
    // makes sure the error send doesn't get intercepted by the
    // permissions middleware
    if (req.flagPermissionChecked) {
        req.flagPermissionChecked();
    }
    res.set(problem.headers);
    res.status(problem.status).send(json);
}

//# sourceMappingURL=errorHandler.js.map