"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "asset", {
    enumerable: true,
    get: function() {
        return asset;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _sequelize = require("sequelize");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const asset = _express.default.Router();
asset.get('/:name', (0, _expressasynchandler.default)(async (req, res)=>{
    req.flagPermissionChecked();
    const { models: { Asset }, params: { name }, query: { facilityId } } = req;
    const assetRecord = await Asset.findOne({
        where: {
            name,
            facilityId: {
                [_sequelize.Op.or]: [
                    facilityId,
                    null
                ]
            }
        },
        order: [
            [
                'facilityId',
                'ASC NULLS LAST'
            ]
        ]
    });
    res.send(assetRecord || {});
}));

//# sourceMappingURL=asset.js.map